# Jukebox

Jukebox is a song manager for Geometry Dash made with the goal of simplifying the process of swapping in-game songs with any NONGs.

## What is a NONG, anyway?

NONG stands for **Not On NewGrounds**. Basically, it means any song that is not available in-game that was replaced manually through external means.

NONGs have always been a hassle to manage, because some level creators use popular Newgrounds song IDs and replace them with a NONG. So you have to swap those song files around quite a bit if you play a level with the Newgrounds song and a level with a NONG song.

## Start your jukebox!

Jukebox makes the process of managing your songs a breeze. You can download your NONGs using your method of choice. My recommandations are: [Cobalt](https://cobalt.tools/) and [yt-dlp](https://github.com/yt-dlp/yt-dlp), a CLI application. After getting your MP3 file, you can enter a song and author name, for easier management.

> Note that Jukebox copies imported songs in the storage location designated by Geode. You can open this folder from ingame.

Alternatively, you can download songs **ingame** from configurable sources, known as indexes. Jukebox provides the **Song File Hub** index as a base, which is a database of NONGs made specifically for Geometry Dash. Ideally, you should be able to get most of the songs you need from here :) 

> You can add your own indexes if you want, more documentation on this will be provided soon!

## So, how do I begin?

You can open up the Jukebox menu from any level page. Just click on the song name, and the song management screen will open. From here, you can add, remove, download and swap songs.

## Reporting bugs

You can report bugs on the [Song FIle Hub Discord server](https://discord.gg/SFE7qxYFyU)

## Credits

- The Geode team, for creating such an amazing toolkit
- Flafy, for creating Auto Nong and afterwards becoming a co-developer
- The nice lads over at Song File Hub for managing the biggest NONG database in GD
- hiimjasmine, for porting the mod to MacOS
- undefined06855, for helping me with parsing song metadata using FMOD

## Licensing

This mod is licensed under **MIT**, so poke around, everything is free as in speech.
